# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class KMSAlias < Resource

    cfn_type 'AWS::KMS::Alias'

    parent_resource :key

    property :alias_name, nil, [nil, String]

    def properties
      alias_name(key.name.to_s) if alias_name.nil?
      {
          TargetKeyId: ref(key, :Arn),
          AliasName: "alias/litany/#{active_environment_name}/#{alias_name}"
      }
    end

  end
end