# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class LambdaPermission < Resource
    cfn_type 'AWS::Lambda::Permission'

    property :action, nil, String
    property :service, nil, String
    property :source_arn, nil, [nil, String, Hash]

    resource_reference LambdaFunction, :function, required: true
    resource_reference EventsRule, :event, required: false

    def properties
      # Unimplemented: SourceAccount

      raise "Don't set both event and source_arn" if set_source_arn? && set_event?

      props = {
          Action: action,
          Principal: service,
          FunctionName: ref(function, :Arn)
      }

      props[:SourceArn] = source_arn if set_source_arn?
      props[:SourceArn] = ref(event, :Arn) if set_event?

      props
    end
  end
end