# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class NetworkLoadBalancerListener < Resource
    cfn_type 'AWS::ElasticLoadBalancingV2::Listener'
    parent_resource :load_balancer

    property :port, nil, 1..65_535
    property :protocol, :tcp, :tcp

    resource_reference NetworkLoadBalancerTargetGroup, :target_group

    def properties
      {
        DefaultActions: [
          {
            TargetGroupArn: ref(target_group),
            Type: :forward
          }
        ],
        LoadBalancerArn: ref(load_balancer),
        Port: port,
        Protocol: protocol.upcase
      }
    end
  end
end
