# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class RDSInstanceOptionGroup < Resource
    include Taggable

    cfn_type 'AWS::RDS::OptionGroup'
    parent_resource :rds_cluster

    property :engine, nil, [:mysql, :mariadb, :oracle_se1, :oracle_se2, :oracle_se, :oracle_ee, :sqlserver_ee, :sqlserver_se, :sqlserver_ex, :sqlserver_web, :postgres, :aurora, :aurora_mysql, :aurora_postgresql], inherited: true
    property :major_version, nil, [String]
    property :description, nil, [String]

    resource_collection RDSInstanceOptionGroupOption, :option, required: false

    def default_tags
      {
        LitanyRDSInstanceOptionGroupName: name
      }
    end

    def properties
      {
        EngineName: engine.tr('_', '-'),
        MajorEngineVersion: major_version,
        OptionGroupDescription: description,
        OptionConfigurations: options
      }
    end
  end
end
