# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class RDSInstanceParameterGroup < Resource
    include Taggable

    cfn_type 'AWS::RDS::DBParameterGroup'
    parent_resource :rds_instance

    property :description, nil, [nil, String]
    property :family, 'aurora5.6', ['aurora5.6', 'aurora-mysql5.7', 'aurora-postgres9.6']

    def default_tags
      {
        LitanyRDSInstanceParameterGroupName: name
      }
    end

    # TODO: Create resource flavors that have proper validation of parameters
    def parameter(key, value)
      parameters[key] = value
    end

    def parameters
      @parameters ||= {}
    end

    def properties
      props = {
        Description: description || "Parameter group for #{rds_instance.resource_name}",
        Family: family,
        Parameters: parameters
      }
    end
  end
end
