# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class RDSSubnetGroup < Resource
    include Taggable

    cfn_type 'AWS::RDS::DBSubnetGroup'
    parent_resource :rds

    property :description, nil, [String, nil]

    def default_tags
      {
          LitanyRDSInstanceSubnetGroupName: name
      }
    end

    def properties
      {
        DBSubnetGroupDescription: description || "Subnet group for #{rds.resource_name}.",
        SubnetIds: ref(rds.vpc.subnets)
      }
    end
  end
end
