# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class RedshiftParameterGroup < Resource
    include Taggable

    cfn_type 'AWS::Redshift::ClusterParameterGroup'
    parent_resource :redshift

    property :description, nil, [nil, String]

    validator(:parameter_set) do
      param_names = parameters.collect { |param| param[:ParameterName] }.to_set
      raise "Duplicate parameter names set for #{redshift.resource_name}" if parameters.count != param_names.count
    end

    def parameters
      @parameters ||= []
    end

    def properties
      {
        Description: description || "Parameter group for #{redshift.resource_name}",
        ParameterGroupFamily: 'redshift-1.0',
        Parameters: parameters
      }
    end

    def set(key, value)
      parameters << {
        ParameterName: key,
        ParameterValue: value
      }
    end
  end
end
