# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class RedshiftSubnetGroup < Resource
    include Taggable

    cfn_type 'AWS::Redshift::ClusterSubnetGroup'
    parent_resource :redshift

    property :description, nil, [String, nil]

    def properties
      {
        Description: description || "Subnet group for #{redshift.resource_name}.",
        SubnetIds: ref(redshift.vpc.subnets)
      }
    end
  end
end
