# frozen_string_literal: true

require 'litany/resource'

module Litany
  class Route < Resource
    cfn_type 'AWS::EC2::Route'
    parent_resource :route_table

    property(:cidr, nil, [String, NetAddr::CIDR]) do |cidr_block|
      NetAddr::CIDR.create(cidr_block)
    end
    property :target, nil, [Resource, String]
    property :target_type, nil, [nil, String]

    def properties
      prop = {
        DestinationCidrBlock: cidr,
        RouteTableId: ref(route_table)
      }

      case target
        when InternetGateway, InternetGateway.id_validator
          prop[:GatewayId] = ref(target)
        when VPCPeeringConnection, VPCPeeringConnection.id_validator
          prop[:VpcPeeringConnectionId] = ref(target)
        else
          raise "Unsupported route target #{target.inspect} detected."
      end

      prop
    end
  end
end
