# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class RouteTable < Resource
    include Taggable

    cfn_type 'AWS::EC2::RouteTable'
    parent_resource :subnet

    child_resource SubnetRouteTableAssociation, :subnet_association

    resource_collection Route, :route

    def add_route(name, cidr:, target:)
      name = [parent_resource.name, 'subnet', name].join('_')

      route name do
        cidr cidr
        target target
      end
    end

    def properties
      {
        VpcId: ref(subnet.vpc)
      }
    end
  end
end
