# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class S3BucketPolicy < Resource
    cfn_type 'AWS::S3::BucketPolicy'
    parent_resource :bucket

    child_resource IAMPolicyDocument, :document

    def properties
      {
        Bucket: ref(bucket),
        PolicyDocument: document
      }
    end
  end
end
