# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class SecretsManagerSecretAttachment < Resource
    child_resource SecretsManagerSecret, :random_secret

    cfn_type 'AWS::SecretsManager::SecretTargetAttachment'

    def properties
      {
        SecretId: ref(random_secret),
        TargetId: ref(parent_resource),
        TargetType: parent_resource.cfn_type,
      }
    end

    def resolve(key)
      random_secret.resolve(key)
    end
  end
end
