# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class SNSTopic < Resource

    cfn_type 'AWS::SNS::Topic'

    output

    property :topic_name, nil, [nil, String]
    resource_collection SNSSubscription, :subscription, required: false

    # Unimplemented: Subscriptions, use sns_subscription collection
    def properties
      { TopicName: topic_name || self.name }
    end

  end
end