# frozen_string_literal: true

require 'litany/resource'

module Litany
  class SubnetRouteTableAssociation < Resource
    cfn_type 'AWS::EC2::SubnetRouteTableAssociation'
    parent_resource :route_table

    def properties
      {
        RouteTableId: ref(route_table),
        SubnetId: ref(route_table.subnet)
      }
    end
  end
end
