# frozen_string_literal: true

require 'litany/resource'

module Litany
  class VPCEndpointService < Resource
    cfn_type 'AWS::EC2::VPCEndpointService'

    child_resource VPCEndpointServicePermissions, :permissions, automatic: :on_access

    flag :acceptance_required, false

    resource_references NetworkLoadBalancer, :load_balancer

    def trust(account:)
      permissions.trust(account: account)
    end

    def properties
      {
        NetworkLoadBalancerArns: ref(load_balancers),
        AcceptanceRequired: acceptance_required?
      }
    end
  end
end
