# frozen_string_literal: true

require 'litany/resource'

module Litany
  class VPCEndpointServicePermissions < Resource
    cfn_type 'AWS::EC2::VPCEndpointServicePermissions'
    parent_resource :endpoint_service

    property_collection :principal, []

    def trust(account:)
      accounts = account.is_a?(Array) ? account : [account]

      accounts.each do |account_id|
        principal arn_builder(service: 'iam', region: nil, account: account_id, resource: 'root')
      end
    end

    def properties
      {
        AllowedPrincipals: principals,
        ServiceId: ref(endpoint_service)
      }
    end
  end
end
