# frozen_string_literal: true

require 'litany/resource'

module Litany
  class VPCInternetGatewayAttachment < Resource
    cfn_type 'AWS::EC2::VPCGatewayAttachment'
    parent_resource :internet_gateway

    def properties
      {
        VpcId: ref(internet_gateway.vpc),
        InternetGatewayId: ref(internet_gateway)
      }
    end
  end
end
