# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class VPCPeeringConnection < Resource
    include Taggable

    cfn_type 'AWS::EC2::VPCPeeringConnection'
    id_validator /pcx-[0-9a-z]{8}/
    parent_resource :vpc

    property :account, nil, [nil, String]
    property :role, nil, [nil, String]

    resource_reference VPC, :target_vpc, required: false

    def properties
      props = {
        VpcId: ref(vpc),
        PeerVpcId: ref(target_vpc)
      }

      props[:PeerOwnerId] = account unless account.nil?
      props[:PeerRoleArn] = role unless role.nil?
      props
    end
  end
end
