# frozen_string_literal: true

require 'litany/resource'

module Litany
  class VPCVPNGatewayAttachment < Resource
    cfn_type 'AWS::EC2::VPCGatewayAttachment'

    resource_reference VPNGateway, :vpn_gateway

    def finalize_resource
      vpn_gateway parent_resource unless set_vpn_gateway?
    end

    def properties
      {
        VpcId: ref(vpc),
        VpnGatewayId: ref(vpn_gateway)
      }
    end

    def vpc
      case parent_resource
        when VPNGateway
          parent_resource.vpc
        when VPC
          parent_resource
        else
          raise "Unexpected parent_resource of type #{parent_resource.class.inspect}."
      end
    end
  end
end
