# frozen_string_literal: true

require 'litany/mixins'
require 'litany/resource'

module Litany
  class VPNGateway < Resource
    include Taggable

    cfn_type 'AWS::EC2::VPNGateway'
    id_validator /vgw-[a-z0-9]{7,14}/
    parent_resource :vpc

    property :propagate, nil, [nil, true, false]

    child_resource VPCVPNGatewayAttachment, :gateway_attachment
    child_resource VPNGatewayRoutePropagation, :route_propagation

    def properties
      { Type: 'ipsec.1' }
    end
  end
end
