# frozen_string_literal: true

require 'litany/resource'

module Litany
  class VPNGatewayRoutePropagation < Resource
    cfn_type 'AWS::EC2::VPNGatewayRoutePropagation'
    parent_resource :vpn_gateway

    resource_references RouteTable, :route_table

    def depends_on
      vpn_gateway.gateway_attachment.resource_name
    end

    def finalize_resource
      vpn_gateway.vpc.subnets.each { |subnet| route_table subnet.route_table }
    end

    def properties
      {
        RouteTableIds: ref(route_tables),
        VpnGatewayId: ref(vpn_gateway)
      }
    end
  end
end
