# frozen_string_literal: true

lib = File.expand_path('../../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)

require 'simplecov'
require 'minitest/autorun'
require 'fileutils'

# Coverage
SimpleCov.profiles.define 'litany' do
  add_group('Core') { |src| File.fnmatch?('**/lib/*.rb', src.filename, File::FNM_PATHNAME) }
  add_group('Resources') { |src| File.fnmatch?('**/lib/resources/**.rb', src.filename, File::FNM_PATHNAME) && File.basename(src.filename) != '_stubs.rb' }
  add_group('Meta Resources') { |src| File.fnmatch?('**/lib/meta_resources/**.rb', src.filename, File::FNM_PATHNAME) && File.basename(src.filename) != '_stubs.rb' }
  add_group('Stubs', '_stubs.rb')
end

SimpleCov.start('litany') { add_filter '/test/' }

# Delay requires until coverage starts
require 'litany'

# Set logging to a file
dir = File.expand_path('../../coverage', __FILE__)
FileUtils.mkdir_p dir unless Dir.exists? dir
Litany::Base.settings.log_target = File.join(dir, 'logs.txt')

