# frozen_string_literal: true

# Global mapping of shorthand codes to AWS regions
AWS_REGIONS = {
  nrt: 'ap-northeast-1',
  icn: 'ap-northeast-2',
  bom: 'ap-south-1',
  sin: 'ap-southeast-1',
  syd: 'ap-southeast-2',
  yul: 'ca-central-1',
  fra: 'eu-central-1',
  dub: 'eu-west-1',
  lhr: 'eu-west-2',
  gru: 'sa-east-1',
  iad: 'us-east-1',
  cle: 'us-east-2',
  sjc: 'us-west-1',
  pdx: 'us-west-2'
}.freeze

# common environment variables
AWS_ECR_URL               = ENV['AWS_ECR_URL'].freeze
CLUSTER_NAME              = ENV['CLUSTER_NAME'].freeze
DEPLOY_ASSUME_ROLE        = ENV['DEPLOY_ASSUME_ROLE'].freeze
DEPLOY_AWS_ACCOUNT        = ENV['DEPLOY_AWS_ACCOUNT'].freeze
DEPLOY_CLOUDWATCH_REGION  = AWS_REGIONS[ENV['DEPLOY_CLOUDWATCH_ENV'].to_sym].freeze
DEPLOY_ENV                = ENV['DEPLOY_ENV'].to_sym.freeze
DEPLOY_TIMEOUT            = (ENV['DEPLOY_TIMEOUT'] || 300).to_i.freeze
DESIRED_COUNT             = ENV['DESIRED_COUNT'].freeze
IMAGE_VERSION             = ENV['IMAGE_VERSION'].freeze
RACK_ENV                  = ENV['RACK_ENV'].freeze
SERVICE_NAME              = ENV['SERVICE_NAME'].freeze
TASK_FAMILY               = ENV['TASK_FAMILY'].freeze
TASK_ROLE                 = ENV['TASK_ROLE'].freeze
TEAMCITY_PROJECT_NAME     = ENV['IMAGE_NAME'].freeze

# matterhorn web environment variables
ARCANA_BUCKET = ENV.fetch('ARCANA_BUCKET').freeze
ARCANA_KEY = ENV.fetch('ARCANA_KEY').freeze
ARCANA_REGION = ENV.fetch('ARCANA_REGION').freeze
ARCANA_SERVICE_ID = ENV.fetch('ARCANA_SERVICE_ID').freeze
AUDIT_S3_BUCKET = ENV.fetch('AUDIT_S3_BUCKET').freeze
AUDIT_SNS_TOPIC = ENV.fetch('AUDIT_SNS_TOPIC').freeze
BOUNCER_AUD = ENV.fetch('BOUNCER_AUD', nil).freeze
BOUNCER_ISS = ENV.fetch('BOUNCER_ISS', nil).freeze
BOUNCER_PUBLIC_KEY_MODULUS = ENV.fetch('BOUNCER_PUBLIC_KEY_MODULUS', nil).freeze
BOUNCER_PUBLIC_KEY_EXPONENT = ENV.fetch('BOUNCER_PUBLIC_KEY_EXPONENT', nil).freeze
GITHUB_URL = ENV.fetch('GITHUB_URL').freeze
REDIS_URL = ENV.fetch('REDIS_URL').freeze
SESSION_KEY = ENV.fetch('SESSION_KEY').freeze
SITE_URL = ENV.fetch('SITE_URL').freeze
TEAMCITY_URL = ENV.fetch('TEAMCITY_URL').freeze

# matterhorn worker environment variables
POLL_INTERVAL = ENV.fetch('POLL_INTERVAL', '10').freeze
