# matterhorn
Git Merge Queue

### Commands to use in PR comments:
* `+merge` - Add this PR to the merge queue.
* `+stop` - Remove this PR from the merge queue.

### Command Modifiers
* `+priority` - Add the PR to the **priority** merge queue. Requires privileged access, configured per-repo; based on GitHub Teams.
* `+admin` - Perform admin override to bypass review requirements. Still enforces that all required checks have passed. Requires privileged access, configured per-repo; based on GitHub Teams.

# Project Configuration Options
All projects are listed in the config yaml files under the top-level `:projects:` object, indexed by the repository name in the standard GitHub format of `<org>/<repo>`. The following config options are available on each project:
```yaml
:name: <display name> # (required) display name for the project in the Savant UI
:branches: # (required) list of PR target branches to allow for the merge queue
  - master
:savant_team: <team name> # (required) mapping of the project to the platform/team in Savant
:required_check_timeout: 900 # (optional, default 600s) timeout to prevent stuck jobs from blocking the merge queue
:allowed_teams: # (optional, default ALL) GitHub Team(s) to allow to use the +merge command
  - Merge Team
:priority_teams: # (optional, default NONE) GitHub Team(s) to allow to use the +priority modifier
  - Priority Merge Team
:admin_teams: # (optional, default NONE) GitHub Team(s) to allow to use the +admin modifier
  - Admin Merge Team
:teamcity:
  :build_type: <TeamCity build ID> # (optional) the ID of a build to link to from the Savant UI
```
