# frozen_string_literal: true

module Matterhorn
  module API
    class Response

      attr_reader :payload
      attr_reader :timestamp

      # Alias to ensure any existing accesses of the out helper still work.
      # @deprecated
      alias_method :out, :payload

      def initialize(data)
        @timestamp = Time.now
        @payload = { timestamp: timestamp }.merge(data)
      end

      def to_json(options = nil)
        payload.to_json(options)
      end
    end
  end
end
