# frozen_string_literal: true

require_relative './environment'
require_relative './logger'
require_relative './validator'

module Matterhorn
  # base class for including common functionality

  class Roda < ::Roda
    # base class for the web app(s)
    include Matterhorn::Environment
    include Matterhorn::Logger

    alias res response
    alias req request

    plugin :environments

    plugin :head
    plugin :all_verbs
    plugin :multi_route
    plugin :indifferent_params
    plugin :request_headers
    plugin :cookies
    plugin :halt
    plugin :render, engine: 'slim', views: 'app/views'

    plugin :not_found do
      '404 Not Found'
    end

    class << self
      # needed for access to these methods during the configuration
      include Matterhorn::Environment
      include Matterhorn::Logger
    end
  end

  class Worker
    # base worker class for handling sidekiq jobs
    include Matterhorn::Environment
    include Matterhorn::Logger
    include Sidekiq::Worker
  end

  class Model
    include Matterhorn::Logger
    include Matterhorn::Validator
  end
end
