# frozen_string_literal: true

module Matterhorn
  module Environment
    def inside?(environment)
      return environment.include?(RACK_ENV) || environment.include?(RACK_ENV.to_sym) if environment.is_a?(Array)
      RACK_ENV == environment.to_s
    end

    def outside?(environment)
      !inside?(environment)
    end

    ['development', 'test', 'production'].each do |environment|
      define_method :"#{environment}?" do
        inside? environment
      end
    end
  end
end
