# frozen_string_literal: true

module Matterhorn
  module Models
    class User < Matterhorn::Model
      def initialize(username, ldap_dn, full_name = nil)
        @username = username
        @ldap_dn = ldap_dn
        @full_name = full_name || ldap_dn.split(',')[0][3..-1].split('(')[0].strip
      end

      def to_json(options = nil)
        {
          username: @username,
          ldap_dn: @ldap_dn,
          name: @full_name
        }.to_json(options)
      end
    end
  end
end
