# frozen_string_literal: true

module Matterhorn
  class Web < Matterhorn::Roda
    route 'api', '_debug' do |r|
      audit_log { |entry| entry.operation_name = 'DebugAPI' }

      r.on 'live' do
        r.get do
          view '_debug/api_live'
        end

        r.post do
          queue = Matterhorn::Models::Queue.new('CPE-Ops/bobsled')
          Matterhorn::FayeMessage.send(channel: '/queue/CPE-Ops/bobsled', data: Matterhorn::API::Response.new(queue: queue, jobs: queue.jobs))
          'Updated'
        end
      end
    end
  end
end
