# frozen_string_literal: true

module Matterhorn
  class Web < Matterhorn::Roda
    route 'faye', '_debug' do |r|
      audit_log { |entry| entry.operation_name = 'DebugFaye' }

      r.get 'client' do
        view '_debug/faye_client'
      end

      r.post 'publish' do
        Matterhorn::FayeMessage.send(channel: '/_debug', data: { text: 'It\'s a small world after all' })
        'It is done.'
      end
    end
  end
end
