# frozen_string_literal: true

module Matterhorn
  class Web < Matterhorn::Roda
    route 'github', 'webhook' do |r|
      r.post do
        if req.headers['x-github-event'] == 'ping'
          'OK'
        else
          Matterhorn::MergeRequest.new(req, body, github).run
        end
      end
    end
  end
end
