# frozen_string_literal: true

require_relative './constants'

# Set default string encoding
Encoding.default_external = 'UTF-8'

require 'bundler/setup'
Bundler.require(:default, RACK_ENV)

# load local libraries and patches
Dir['./app/lib/**/*.rb'].sort.each { |file| require file }

module Matterhorn
  class Web < Matterhorn::Roda; end
end

# load everything else
Dir['./app/helpers/**/*.rb'].sort.each { |file| require file }
Dir['./app/workers/**/*.rb'].sort.each { |file| require file }
require './app/app'
Dir['./app/routes/**/*.rb'].sort.each { |file| require file }
Dir['./app/models/**/*.rb'].sort.each { |file| require file }
