# frozen_string_literal: true

require 'yaml'
require 'json'
require_relative './env'

RACK_ENV = ENV.fetch('RACK_ENV').freeze

# Get the root directory of the application
APP_ROOT = File.expand_path('..', __dir__) unless defined?(APP_ROOT)

# Supported projects
PROJECTS = YAML.load_file(File.expand_path("../projects/#{RACK_ENV}.yml", __FILE__))
PROJECT = ENV.fetch('PROJECT') { nil }.freeze

# Arcana constants
ARCANA_BUCKET = ENV.fetch('ARCANA_BUCKET').freeze
ARCANA_KEY = ENV.fetch('ARCANA_KEY').freeze
ARCANA_PROFILE = ENV.fetch('ARCANA_PROFILE') { nil }.freeze # for local dev
ARCANA_REGION = ENV.fetch('ARCANA_REGION').freeze
ARCANA_SERVICE_ID = ENV.fetch('ARCANA_SERVICE_ID').freeze

# Bouncer auth contants
BOUNCER_SERVICE = 'Matterhorn'
BOUNCER_TENANT = 'Web'
BOUNCER_TARGET_ENV = (RACK_ENV == 'production' ? 'Prod' : 'Shadow')

ROLES = {
  admin: "#{BOUNCER_SERVICE}:#{BOUNCER_TENANT}:#{BOUNCER_TARGET_ENV}:MatterhornAdmin",
  queue_manager: PROJECTS[:platforms].keys.map do |key|
    # if we've configured a custom mapping for bouncer_tenants, use that
    team = PROJECTS[:bouncer_tenants][key] unless PROJECTS[:bouncer_tenants].nil?
    # else default to our standard sanitized version of the savant team name
    team ||= key.to_s.split('-').map { |part| part.length == 2 ? part.upcase : part.capitalize }.join
    [key, "#{BOUNCER_SERVICE}:#{team}:#{BOUNCER_TARGET_ENV}:QueueManager"]
  end.to_h
}.freeze

# Application secrets
require_relative '../config/secrets'

# audit log constants
AUDIT_S3_BUCKET = ENV.fetch('AUDIT_S3_BUCKET').freeze
AUDIT_SNS_TOPIC = ENV.fetch('AUDIT_SNS_TOPIC').freeze

# Application environment variables
SITE_URL = ENV.fetch('SITE_URL').freeze
WEBHOOK_URL = "#{SITE_URL}/hook/github"
SESSION_KEY = ENV.fetch('SESSION_KEY', 'matterhorn.csi.twitch').freeze

REDIS_URL = ENV.fetch('REDIS_URL').freeze
FAYE_REDIS_HOST = ENV.fetch('FAYE_REDIS_HOST', URI(REDIS_URL)).host.freeze
FAYE_REDIS_PORT = ENV.fetch('FAYE_REDIS_PORT', URI(REDIS_URL)).port.freeze
FAYE_REDIS_DB = ENV.fetch('FAYE_REDIS_DB', 1).freeze

GITHUB_URL = ENV.fetch('GITHUB_URL', 'https://git.xarth.tv/api/v3').freeze
GITHUB_USERNAME = ENV.fetch('GITHUB_USERNAME', 'cpe-services').freeze

TEAMCITY_URL = ENV.fetch('TEAMCITY_URL', 'https://teamcity.xarth.tv').freeze

# Worker environment variables
DEFAULT_JOB_TIMEOUT = ENV.fetch('DEFAULT_JOB_TIMEOUT', 600).freeze
POLL_INTERVAL = ENV.fetch('POLL_INTERVAL', 10).to_i.freeze
