# frozen_string_literal: true

ENV['RACK_ENV'] ||= 'development'
envs = ['.env', ".env.#{ENV['RACK_ENV']}"]

envs.each do |e|
  next unless File.file?(e)
  File.foreach(e) do |line|
    line.strip!
    next if line =~ /^#/ || line.empty?
    key, value = line.split('=', 2)
    ENV[key] = value.gsub('\n', '').strip
  end
end
