# frozen_string_literal: true

require 'arcana'

ARCANA = Arcana::Client.new(bucket: ARCANA_BUCKET, service_id: ARCANA_SERVICE_ID, system_prefix: nil, aws_profile: ARCANA_PROFILE)

# safe decrypt, so we can still use env vars in local dev
def arcana_decrypt(key)
  if RACK_ENV == 'development' && !ENV[key.upcase].nil?
    Matterhorn::LogClient.warn "Getting development secret value for #{key.upcase} from the environment"
    return ENV[key.upcase]
  end
  ARCANA.decrypt_and_strip(key)
rescue Aws::S3::Errors::NoSuchKey => e
  return nil if RACK_ENV == 'development'

  raise e
end

ORKO_DOMAIN = arcana_decrypt('orko_domain')
GITHUB_ACCESS_TOKEN = arcana_decrypt('github_access_token')
MATTERHORN_SECRET_KEY = arcana_decrypt('matterhorn_secret_key')
TEAMCITY_USERNAME = arcana_decrypt('teamcity_username')
TEAMCITY_PASSWORD = arcana_decrypt('teamcity_password')
WEBHOOK_SECRET = arcana_decrypt('webhook_secret')
