```plantuml
@startuml
!define AWSPuml https://raw.githubusercontent.com/awslabs/aws-icons-for-plantuml/master/dist
!include AWSPuml/AWSCommon.puml
!include AWSPuml/Compute/ECSContainer2.puml
!include AWSPuml/Compute/ECSService.puml
!include AWSPuml/Database/ElastiCache.puml
!include AWSPuml/Storage/SimpleStorageServiceS3.puml

title Matterhorn Data Flow Diagram

actor "User" as user
actor "Admin" as admin
[Savant] as savant <<React UI>>
[Orko] as orko <<PR Notification Bot>>
[GitHub Enterprise API] as ghe <<Source Code Metadata>>
[TeamCity API] as teamcity <<Build Pipeline Metadata>>
[Audit Log Service (CDP/Delivery)] as audit <<Audit Logging>>
ECSService(matterhornWebService, "MatterhornWeb", "GitHub Merge Queue API")
ECSService(matterhornWorkerService, "MatterhornWorker", "GitHub Merge Queue Workers")
ElastiCache(matterhornData, "Matterhorn Data", "Queue Storage and Short-lived GHE/TeamCity Data Cache")

user -> savant : via Osiris
savant --> matterhornWebService : API
matterhornWebService --> savant : websocket

matterhornWebService <-> matterhornData

matterhornWebService --> ghe : API
ghe --> matterhornWebService : Webhook

matterhornWebService --> teamcity : API

matterhornWebService --> audit

matterhornWorkerService <-> matterhornData

matterhornWorkerService --> orko : Merge Status
orko --> matterhornWebService : Queue API

admin -> matterhornWebService : via TwitchVPN
@enduml
```

```plantuml
@startuml
!define AWSPuml https://raw.githubusercontent.com/awslabs/aws-icons-for-plantuml/master/dist
!include AWSPuml/AWSCommon.puml
!include AWSPuml/Compute/EC2AutoScaling.puml
!include AWSPuml/Compute/EC2Instance.puml
!include AWSPuml/Compute/ECSContainer2.puml
!include AWSPuml/Compute/ECSService.puml
!include AWSPuml/Database/ElastiCache.puml
!include AWSPuml/NetworkingAndContentDelivery/PrivateLink.puml
!include AWSPuml/NetworkingAndContentDelivery/VPC.puml
!include AWSPuml/NetworkingAndContentDelivery/VPCPeering.puml

title Matterhorn AWS Infrastructure Diagram

frame "994136867826 twitch-cpe+tools@amazon.com" {
  VPC(vpc, "CPEDevVPC", "Shared VPC for legacy clients tools")

  VPCPeering(scienceLegacy, "twitch-aws-owners", "twitch-aws-owners+science@amazon.com (673385534282)")

  EC2Instance(teamcity, "TeamCity", "TeamCity Server")

  EC2AutoScaling(servicesECSCluster, "services", "Services ECS Cluster")

  ECSService(audit, "AuditLogService", "Legacy CSI Audit Service")
  ECSService(savant, "Savant", "React UI")

  package "MatterhornWeb" {
    ECSService(matterhornWebService, "matterhorn", "Web API ECS Service")
    ECSContainer2(matterhornWebTask, "matterhorn", "Web ECS Tasks")
    ECSContainer2(matterhornWebTask2, "matterhorn", "Web ECS Tasks")
    ECSContainer2(matterhornWebTask3, "matterhorn", "Web ECS Tasks")
    ECSContainer2(matterhornWebTask4, "matterhorn", "Web ECS Tasks")
  }

  ElastiCache(matterhornData, "Matterhorn Data", "Queue Storage and Short-lived GHE/TeamCity Data Cache")

  package "MatterhornWorker" {
    ECSService(matterhornWorkerTwilightService, "matterhorn-worker-twilight-twilight", "Worker ECS Services")
    ECSContainer2(matterhornWorkerTwilightTask, "matterhorn-worker-twilight-twilight", "Worker ECS Task, Limit 1")

    ECSService(matterhornWorkerPlayerCoreService, "matterhorn-worker-video-player-core", "Worker ECS Services")
    ECSContainer2(matterhornWorkerPlayerCoreTask, "matterhorn-worker-video-player-core", "Worker ECS Task, Limit 1")

    ECSService(matterhornWorkerCoreUIService, "matterhorn-worker-core-ui-core-ui", "Worker ECS Services")
    ECSContainer2(matterhornWorkerCoreUITask, "matterhorn-worker-core-ui-core-ui", "Worker ECS Task, Limit 1")

    ECSService(matterhornWorkerMatterhornService, "matterhorn-worker-cpe-ops-matterhorn", "Worker ECS Services")
    ECSContainer2(matterhornWorkerMatterhornTask, "matterhorn-worker-cpe-ops-matterhorn", "Worker ECS Task, Limit 1")

    ECSService(matterhornWorkerTachyonService, "matterhorn-worker-mobile-web-tachyon", "Worker ECS Services")
    ECSContainer2(matterhornWorkerTachyonTask, "matterhorn-worker-mobile-web-tachyon", "Worker ECS Task, Limit 1")

    ECSService(matterhornWorkerElectronService, "matterhorn-worker-desktop-electron-platform", "Worker ECS Services")
    ECSContainer2(matterhornWorkerElectronTask, "matterhorn-worker-desktop-electron-platform", "Worker ECS Task, Limit 1")

    ECSService(matterhornWorkerDesktopService, "matterhorn-worker-desktop-desktop", "Worker ECS Services")
    ECSContainer2(matterhornWorkerDesktopTask, "matterhorn-worker-desktop-desktop", "Worker ECS Task, Limit 1")
  }
}

frame "673385534282 twitch-aws-owners+science@amazon.com" {
  EC2Instance(github, "GitHub Enterprise", "GitHub Enterprise") 
}

frame "708209600803 twitch-cpe+orko@amazon.com" {
  ECSService(orko, "OrkoWeb", "Public webhook endpoint")
}

servicesECSCluster .. audit
servicesECSCluster .. savant

vpc .. teamcity
vpc .. servicesECSCluster
vpc .. scienceLegacy

scienceLegacy .. github

servicesECSCluster .. matterhornWebService
servicesECSCluster .. matterhornWorkerTwilightService
servicesECSCluster .. matterhornWorkerPlayerCoreService
servicesECSCluster .. matterhornWorkerCoreUIService
servicesECSCluster .. matterhornWorkerMatterhornService
servicesECSCluster .. matterhornWorkerTachyonService
servicesECSCluster .. matterhornWorkerElectronService
servicesECSCluster .. matterhornWorkerDesktopService

matterhornWebService .. matterhornWebTask
matterhornWebService .. matterhornWebTask2
matterhornWebService .. matterhornWebTask3
matterhornWebService .. matterhornWebTask4

matterhornWorkerTwilightService .. matterhornWorkerTwilightTask
matterhornWorkerPlayerCoreService .. matterhornWorkerPlayerCoreTask
matterhornWorkerCoreUIService .. matterhornWorkerCoreUITask
matterhornWorkerMatterhornService .. matterhornWorkerMatterhornTask
matterhornWorkerTachyonService .. matterhornWorkerTachyonTask
matterhornWorkerElectronService .. matterhornWorkerElectronTask
matterhornWorkerDesktopService .. matterhornWorkerDesktopTask

matterhornWebTask --> matterhornData
matterhornWebTask2 --> matterhornData
matterhornWebTask3 --> matterhornData
matterhornWebTask4 --> matterhornData

matterhornWorkerTwilightTask --> matterhornData
matterhornWorkerPlayerCoreTask --> matterhornData
matterhornWorkerCoreUITask --> matterhornData
matterhornWorkerMatterhornTask --> matterhornData
matterhornWorkerTachyonTask --> matterhornData
matterhornWorkerElectronTask --> matterhornData
matterhornWorkerDesktopTask --> matterhornData
@enduml
```
