require "test_helper"
require "faye_sign_middleware"

class FayeSignMiddlewareTest < Minitest::Test
  def setup
    @faye = ::Matterhorn::FayeSignMiddleware.new
  end

  def test_that_it_parses_a_valid_project_name
    parsed = @faye.project_name('/queue/twilight/twilight')
    assert_equal('twilight/twilight', parsed, 'Failed to parse project name')
  end

  def test_that_it_rejects_an_invalid_project_name
    parsed = @faye.project_name('/should/not/match')
    assert_nil(parsed, 'Accepted invalid project name')
  end
end
