import jetbrains.buildServer.configs.kotlin.v2018_2.version
import twitch.instrumentorum.enums.BranchFilter
import twitch.instrumentorum.instrum
import twitch.instrumentorum.project.builds.dockerBuildAndPush
import twitch.instrumentorum.project.builds.initializeBuildChain
import twitch.instrumentorum.project.steps.verifyECRRepository

version = "2018.2"

instrum {
    description = "Intermediary container for nodejs services"
    sourceRoot("git@git-aws.internal.justin.tv:CPE-Ops/nodejs-dumb-init.git")

    textParam("ecr.repo", "nodejs-dumb-init", "ECR Repository", "The name used the ECR Repository")

    initializeBuildChain {
        verifyECRRepository("%ecr.repo%")
    }

    dockerBuildAndPush("Build and Publish") {
        tag = paramFrom("Initialize Build Chain", "git.version")
        vcsTrigger(BranchFilter.NO_DEFAULT)
    }
}
