import jetbrains.buildServer.configs.kotlin.v2018_2.version
import twitch.instrumentorum.enums.BranchFilter
import twitch.instrumentorum.instrum
import twitch.instrumentorum.project.builds.dockerBuildAndPush
import twitch.instrumentorum.project.builds.initializeBuildChain

version = "2018.2"

instrum {
    description = "Intermediary container for nodejs containers"
    sourceRoot("git@git-aws.internal.justin.tv:CPE-Ops/nodejs.git")

    textParam("ecr.repo", "nodejs", "ECR Repository", "The name used the ECR Repository")

    initializeBuildChain()
    dockerBuildAndPush("Build and Publish") {
        tag = paramFrom("Initialize Build Chain", "git.version")
        vcsTrigger(BranchFilter.NO_DEFAULT)
    }
}
