#include <dlfcn.h>
#include <pthread.h>
#include <stdio.h>

// libmusl has a significantly different behavior on stack sizes.  Results in it being possible to segfault in some apps.
// This is preventing certain node/npm commands from working. Sauce: https://github.com/nodejs/docker-node/issues/813#issuecomment-407339011
// This script works around this issue.
typedef int (*func_t)(pthread_t *thread, const pthread_attr_t *attr, void *(*start_routine)(void*), void *arg);

int pthread_create(pthread_t *thread, const pthread_attr_t *attr, void *(*start_routine)(void*), void *arg) {

    pthread_attr_t local;
    int used = 0, ret;

    if (!attr) {
        used = 1;
        pthread_attr_init(&local);
        attr = &local;
    }

    pthread_attr_setstacksize((void*)attr, 2 * 1024 * 1024); // 2 MB

    func_t orig = (func_t)dlsym(RTLD_NEXT, "pthread_create");
    ret = orig(thread, attr, start_routine, arg);

    if (used) {
        pthread_attr_destroy(&local);
    }

    return ret;
}
