const path = require('path');
const slsw = require('serverless-webpack');
const nodeExternals = require('webpack-node-externals');

module.exports = {
  entry: slsw.lib.entries,
  target: 'node',
  mode: slsw.lib.webpack.isLocal ? 'development': 'production',
  optimization: {
    minimize: !slsw.lib.webpack.isLocal
  },
  performance: {
    hints: false
  },
  module: {
    rules: [
      { test: /\.ts(x?)$/, loader: 'ts-loader' }
    ]
  },
  externals: [nodeExternals()],
  resolve: {
    extensions: ['.ts', '.js', '.tsx', '.jsx']
  },
  output: {
    libraryTarget: 'commonjs',
    path: path.join(__dirname, '.webpack'),
    filename: 'handler.js'
  },
};
