# frozen_string_literal: true

class String
  def indent(depth = 1, size = 4)
    split("\n", -1).collect { |line| (' ' * size * depth) + line }.join("\n")
  end
end

class Numeric
  def pretty
    to_s.reverse.gsub(/(\d{3})(?=\d)/, '\\1,').reverse
  end
end
