# frozen_string_literal: true

require 'pain/constants'

require 'sequel'

module Pain
  DB = Sequel.connect(CONNECTION_STRING)
  DB.extension :connection_validator


  Sequel::Model.plugin :update_or_create

  models_splat = File.join(File.dirname(__FILE__), 'models', '*.rb')
  Dir[models_splat].each { |model| require model }

  DB.freeze
  DB.disconnect
end
