# frozen_string_literal: true

Sequel.migration do
  change do
    create_table (:acm_certificates) do
      primary_key :id

      column :arn, String, null: false, unique: true

      column :profile, String, null: false
      column :region, String, null: false

      column :domain_name, String, null: false
      column :alternate_names, String, null: false

      column :validation_methods, String, null: false
      column :validation_emails, String, null: false
      # column :validation_records, String, null: false, default: ''

      # column :serial, String, null: false
      # column :subject, String, null: false
      # column :issuer, String, null: false
      #
      # column :created_at, Time, null: false
      # column :issued_at, Time, null: true
      # column :imported_at, Time, null: true
      # column :revoked_at, Time, null: true
      column :not_before, Time, null: true
      column :not_after, Time, null: true

      column :status, String, null: false
      # column :revocation_reason, String, null: false
      # column :key_algorithm, String, null: false
      # column :signature_algorithm, String, null: false
      #
      # column :users, String, null: false, default: ''
      # column :failure_reason, String, null: true
      # column :type, String, null: false
      # column :renewal_summary, String, null: false
      column :renewal_eligibility, String, null: false
      column :in_use_by, Integer, default: 0
    end
  end
end
