# How to Deploy Teleport Remote to a New Region

## Naming Standards

* Regions in litany should follow our (CSI) standard airport code conventions.
* The teleport cluster name should follow this pattern `csi-security-services-pdx` while replacing pdx for the new region's airport code.
* The teleport cluster's sandstorm role name should be the cluster name prepended with `teleport-remote-`. (e.g. `teleport-remote-csi-security-services-pdx`)

## Part 1: Infrastructure

> **Pro tip:** The first two steps in this guide involve asynchronous tickets with other teams.  It's recommended to start those as soon as possible.  You can also batch those two steps, so you're submitting the tickets for multiple regions at once.

1. Request a new CIDR for the regions VPC.  For IAD, SIN, LHR, and PDX this can be done through the [self-service portal][1].  For all other regions open a [NET Jira Issue][2]
1. Follow the setups under [Teleport Remote's guide for 'Create an IAM Role in Sandstorm'][3].  This step involves creating a ticket with Security.
1. Ensure an appropriate environment block exists in `environment.lit`.
    ```ruby
    environment :lhr do
      region :eu_west_1
    end
    ```
1. Create a new `inside` block in `settings.lit` with the data for the new region.

    ```ruby
    inside :lhr do
      set :cidr, '10.299.132.0/22'

      set :zone_a, :eu_west_2a
      set :zone_b, :eu_west_2b
      set :zone_c, :eu_west_2c
    end
    ```

    * In the above example, replace `:lhr` with the region code for the new region.
    * The value of `:cidr` must be the CIDR issued in step 1.
    * The zone mapping is critical, and is different in each region. We need 2-3 AZs in each region.  This project is set up to handle zones A through D without further changes.  Confirm the zones available in this new region via the console or the below cli replacing region appropriately.
        ```bash
        aws --profile security-services --region us-east-1 ec2 describe-availability-zones
        ```
1. Add your new region code the list of `environments` in `settings.lit`.  It should look similar to the below example but will have every deployed region in the list.
    ```ruby
    set :environments, [:pdx, :iad, :lhr]
    ```
1. Run a `lit upload` command targeting the new region.  Upload the VPC stack first, and then upload any additional stacks afterward.

## Part 2: Teleport Remote

This part requires that Part 1 is completed in full before you can begin.  Generally, we're going to follow the guide under [Teleport Remote's guide for 'Deploy the CloudFormation stack'][4].  However please observe the following conventions for naming and parameters:

* **Stack Name**: use the sandstorm role name. (e.g. `teleport-remote-csi-security-services-pdx`)
* **Cluster Name**: use the shorter form discussed in the naming standards towards the top of this document. (e.g. `csi-security-services-pdx`)
* **VPC/Subnets**: ensure you're attaching to the litany created VPC from Part 1.  Use all subnets in that VPC.
* **Instance Type**: use `t3.medium`
* **Instance Count**: Should match the number of AZs you're using in this region.  Normally this will be 2 or 3.
* **Maintenance Day/Hour**: I currently think that the best time for this is approximately 7 am PST midweek which would be day 2 hour 14.
* **Release Channel**: use `late`

All other options leave to their defaults.

## Validation & Next Steps

At this point, you should have a functioning teleport remote cluster.  You can validate that the cluster is online and connected by checking [this graph][5].  It can take ten to twenty minutes after the stack is in a 'COMPLETED' before it shows up on said graph.

Unfortunately, the story is only part of the way done.  To start using teleport as our bastion in a region, you must peer the new VPC with *each* VPC we have in that region.  This process is covered in another runbook.

[1]: https://aws-vpc-api.internal.justin.tv/
[2]: https://jira.twitch.com/projects/NET
[3]: https://wiki.twitch.com/display/SEC/Teleport+Remote#TeleportRemote-CreateanIAMRoleinSandstorm
[4]: https://wiki.twitch.com/display/SEC/Teleport+Remote#TeleportRemote-DeploytheCloudFormationstack
[5]: https://grafana.internal.justin.tv/d/yEPTntOiz/teleport-tunnels-production?orgId=1&from=now-1h&to=now
