# Setting up Your Workstation for Teleport Usage

This guide is intended to be supplemental to the [official security documentation][1] around setting up your workstation.

## Quick Start on Mac OS

> Note: Other OSs have installation instructions inside of the [official documentation][1].  As most of our team uses Mac OS, I've copied the relevant portions here.

1. This process requires Homebrew.  If you don't have Homebrew installed follow [this guide][2] first.
1. Once Homebrew is healthy, you can confirm this by running `brew doctor`, run the following commands.
    ```bash
    brew tap --full twitch/security https://twitch-security-packages.s3.amazonaws.com/homebrew.git && brew update
    brew install twitch-bastion-util
    ```

## Configuration

> Note: With the likely exception of non-linux subsystem Windows installs this part of the guide applies to all OSes.  Even then some of the tips will apply there as well.

By default Teleport is installed and intercepts nearly 100% of your ssh sessions, it also makes a few other assumptions.  Our current thinking is that this is potentially overkill and not necessarily needed.  Some steps are flagged as critical and should _absolutely_ be followed.

1. ❗If your LDAP username and local system username do not match exactly, you need to configure teleport with the following command.
    ```bash
    teleport-bastion config ldap_username <ldap username>
    ```
    You would still need to prepend each server name with `<ldap username>@` when using ssh, to avoid this you can place the following in your `~/.ssh/config` file.
    ```
    Host *.twitch.cloud
      User <ldap username>
    ```

1. ❗ Similarly, your server username must also match your LDAP username.  If this is not the case, please open a [COPS ticket][5] to have your server user recreated.
1. ❗If you're on a Mac OS Amazon image, your user likely does not have a login shell by default.  Having this unset would result in you getting "/bin/false: No such file or directory" when trying to SSH via bastion.  There is a [guide from security on this issues][4] as well as a [guide on Amazon's wiki about how to change the setting][3], but the below terminal command should work as well.
    ```bash
    chsh -s /bin/bash
    ```
    If you prefer ZSH you can set that instead:
    ```bash
    chsh -s /bin/zsh
    ```
1. By default, teleport uses a blacklist system where all ssh is proxied over it except a specific list.  Our current thought is that whitelisting will be less problematic as we roll the usage out. Run the following to adopt our current whitelisting pattern, but you can adjust the lists to suit your needs.
    ```bash
    teleport-bastion config bastion_ssh_targets "git-aws.internal.justin.tv,*.twitch.cloud"
    teleport-bastion config bastion_ssh_exclusions "127.0.0.1"
    ```

## Using Teleport Remotes

Teleport does not have any concept of which remote to which a given server belongs.  As such we have to specify the target remote cluster when we connect.

```bash
TC=csi-security-services-pdx ssh seinfeld-pdx.twitch.cloud
```
The TC environment variable should never be exported but also must be present or the central teleport servers will be selected, and they are unable to access our servers directly.

## SSH Helper

Setting TC manually is somewhat cumbersome.

We have a Bash and ZSH compatible helper that shadows the ssh command and intelligently set the TC variable when you attempt to SSH into a server with a well-formed `twitch.cloud` hostname. It also has a few other quality of life improvements.  To install place this inside of your shell config file and restart your terminal session.

```bash
ssh () {
    args="$@"
    regex=".+-([a-z]{3})\.(.+\.)?twitch.cloud"

    if [[ $args =~ $regex ]]; then
        if ! [[ -x "$(command -v teleport-bastion)" ]]; then
            echo "Teleport bastion was not found on your system.  Please ensure this is installed and configured properly."
            exit 1
        fi

        if ! (teleport-bastion status | grep -q enabled ); then
            echo "Notice: Running 'teleport-bastion -y enable' to enable teleport."
            teleport-bastion -y enable
            echo
        fi

        if [[ -n $BASH_VERSION ]]; then
            region=${BASH_REMATCH[1]};
        elif [[ -n $ZSH_VERSION ]]; then
            region=${match[1]};
        fi

        TC=csi-security-services-${region} command ssh $@
    else
        if ( echo $args | grep -q 'twitch.cloud' ); then
            echo "Warning: Unable to determine region for a twitch.cloud domain name. Teleport Remote has not been set for this session."
            echo
        fi

        command ssh $@
    fi
}
```

[1]: https://wiki.twitch.com/display/SEC/Teleport+Bastion#TeleportBastion-QuickStart
[2]: https://docs.brew.sh/Installation
[3]: https://w.amazon.com/index.php/ClientEng/Mac/Terminal_Shell_Troubleshooting
[4]: https://wiki.twitch.com/display/SEC/Local+User+Login+Shell+Troubleshooting
[5]: https://jira.twitch.com/browse/COPS-649