class String
  def deflate(level=9)
    zlib = Zlib::Deflate.new(level)
    return zlib.deflate(self, Zlib::FINISH)
  ensure
    zlib.close unless zlib.nil?
  end

  def inflate
    zlib = Zlib::Inflate.new
    return zlib.inflate self
  ensure
    zlib.close unless zlib.nil?
  end

  def dashcase
    self.gsub(/([A-Z])([A-Z][a-z])/,'\1-\2').
        gsub(/([a-z\d])([A-Z][a-z\d])/,'\1-\2').
        tr('(', '-').tr(')', '').tr('_', '-').
        downcase
  end

  def snakecase
    self.gsub(/([A-Z])([A-Z][a-z])/,'\1_\2').
        gsub(/([a-z\d])([A-Z][a-z\d])/,'\1_\2').
        tr('-', '_').tr('(', '_').tr(')', '').
        gsub(/(.*?)_+(.*?)/, '\1_\2').downcase
  end

  def to_numeric
    Integer(self)
  rescue
    Float(self)
  end

  def is_numeric?
    true if Float(self) rescue false
  end
end

class Numeric
  def is_numeric?
    true
  end

  def to_numeric
    self
  end

  def to_formatted_s
    self.to_s.reverse.gsub(/(\d{3})(?=\d)/, '\\1,').reverse
  end
end