# frozen_string_literal: true
# coding: utf-8

lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)

require 'sensu/extension/tueor/version'

Gem::Specification.new do |spec|
  raise 'RubyGems 2.0 or newer is required to protect against public gem pushes.' unless spec.respond_to?(:metadata)

  spec.name          = 'sensu-extension-tueor'
  spec.version       = Sensu::Extension::Tueor::VERSION
  spec.authors       = ['Bryan McLemore']
  spec.email         = ['mclemore@twitch.tv']

  spec.summary       = 'A standard base gem for sensu extensions'
  spec.description   = 'A standard base gem for sensu extensions'
  spec.homepage      = 'https://git-aws.internal.justin.tv/CPE-Ops/sensu-extension-tueor'

  # Prevent pushing this gem to RubyGems.org. To allow pushes either set the 'allowed_push_host'
  # to allow pushing to a single host or delete this section to allow pushing to any host.
  spec.metadata['allowed_push_host'] = 'https://gems.cpe.wtf'

  spec.files = `git ls-files -z`.split("\x0").reject do |f|
    f.match(%r{^(test|spec|features)/})
  end
  spec.bindir        = 'exe'
  spec.executables   = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }
  spec.require_paths = ['lib']

  spec.add_dependency 'childprocess'
  spec.add_dependency 'command-builder'
  spec.add_dependency 'em-http-request'
  spec.add_dependency 'sensu-extension'

  spec.add_development_dependency 'bundler', '~> 1.15'
  spec.add_development_dependency 'rake', '~> 10.0'
  spec.add_development_dependency 'minitest', '~> 5.0'
  spec.add_development_dependency 'rubocop', '~> 0.49'

  spec.add_development_dependency 'sensu-logger'
  spec.add_development_dependency 'sensu-settings'
end
