# frozen_string_literal: true

require 'test_helper'
require 'eventmachine'
require 'em-http-request'

class BigFileTest < Sensu::Extension::TueorCheck

  step(:read_big_file, :message) do
    path = File.join(File.dirname(__FILE__), '1MB')
    read_file(path) do |output|
      set :message, output[-1]
    end
  end

  def critical?
    false
  end

  def warning?
    false
  end
end

class TueorTest < Minitest::Test
  include TestHelpers

  def test_big_file_check
    check = BigFileTest.new
    run_extension check, data: check_template do |output, status|
      puts "Out: #{output}, Status: #{status}"
    end

    puts "Extension Data: #{check.instance_variable_get(:@data).inspect}"
  end
end
