# frozen_string_literal: true

require 'test_helper'
require 'eventmachine'
require 'em-http-request'

class LoadCheck < Sensu::Extension::TueorCheck
  prep_step(:get_cores, :cores) do
    path = File.join(File.dirname(__FILE__), 'cpuinfo')
    command(:grep).arg(:c).params('processor', path) do |output|
      set :cores, output.to_i
      set :critical_threshold, [cores * 15, cores * 10, cores * 7.5]
      set :warning_threshold, [cores * 3, cores * 2, cores * 1.5]
    end
  end

  step(:get_averages, :averages, :message) do
    path = File.join(File.dirname(__FILE__), 'loadavg')
    read_file(path) do |output|
      set :averages, output.split.take(3).collect(&:to_f)
      set :message, averages.join('  ')
    end
  end

  def critical?
    averages.zip(critical_threshold).any? { |avg, threshold| avg > threshold }
  end

  def warning?
    averages.zip(warning_threshold).any? { |avg, threshold| avg > threshold }
  end
end

class TueorTest < Minitest::Test
  include TestHelpers

  def test_load_check
    check = LoadCheck.new
    run_extension check, data: check_template do |output, status|
      puts "Out: #{output}, Status: #{status}"
    end

    puts "Extension Data: #{check.instance_variable_get(:@data).inspect}"
  end
end
